implementation module deltaIOState

import intrface
import ioTypes, StdEnv, clCrossCall
import Events
from Window0 import FindWindowWithHandle

Void :== 0

/*	IOState is an instance of the FileEnv class (see StdFile):	*/
instance FileEnv (IOState s) where
	accFiles :: !.(*Files -> (.x,*Files)) !(IOState s) -> (!.x,!IOState s)
	accFiles accfun io
		# (w,io)	= IOStateGetWorld io
		  (x,w)		= accFiles accfun w
		  io		= IOStateSetWorld w io
		= (x,io);
	
	appFiles :: !.(*Files -> *Files) !(IOState s) -> IOState s
	appFiles appfun io
		# (w,io)	= IOStateGetWorld io
		  w			= appFiles appfun w
		  io		= IOStateSetWorld w io
		= io

/*	ObscureCursor hides the cursor until the mouse is moved. */
ObscureCursor :: !(IOState s) -> IOState s
ObscureCursor iostate = PackIOState adm newos
where
  (adm, os) = UnpackIOStateWithCheck iostate
  newos     = WinObscureCursor os



:: DoubleDownDist :== Int

/*	Set the maximum distance the mouse is allowed to move to generate a
	ButtonDouble(Triple)Down button state. Negative values are set to zero. */
SetDoubleDownDistance :: !DoubleDownDist !(IOState s) -> IOState s
SetDoubleDownDistance d iostate = PackIOState adm newos
where
  d2        =  if (d < 0) 0 d
  (adm, os) =  UnpackIOStateWithCheck iostate
  newos     =  WinSetDoubleDownDist d2 os


/*	Set the shape of the cursor globally. This shape overrules the local cursor
	shapes of windows. */
SetGlobalCursor :: !CursorShape !(IOState s) -> IOState s
SetGlobalCursor shape iostate = PackIOState adm newos
where
  (adm, os)    =  UnpackIOStateWithCheck iostate
  cursorcode   =  CursorShape2Code shape
  setcci       =  ( CcRqSETGLOBALCURSOR, cursorcode, 0,0,0,0,0 )
  (_,_, newos) =  IssueCleanRequest (ErrorCallback "SetGlobalCursor") setcci Void os


/*	Undoes the effect of SetGlobalCursor. */
ResetCursor :: !(IOState s) -> IOState s
ResetCursor iostate = PackIOState adm newos
where
  (adm, os)    =  UnpackIOStateWithCheck iostate
  resetcci     =  ( CcRqRESETCURSOR, 0,0,0,0,0,0 )
  (_,_, newos) =  IssueCleanRequest (ResetCallback adm) resetcci Void os

  ResetCallback adm (CcWmSETCURSOR, hwnd, _,_,_,_,_) s os 
    = case FindWindowWithHandle hwnd adm.io_windowState of
		Nope      -> ( False, Return0Cci, s, os)
		OK window -> ( True,  returncci,  s, os)
			where
			  returncci   =  Return1Cci (CursorShape2Code window.wcursor)
  ResetCallback adm cci s os = (True, Return0Cci, s, os)

